<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');
 
jimport('joomla.form.formfield');
 
class JFormFieldColorpicker extends JFormField {
 
        protected $type = 'colorpicker';
 
		public function getLabel() {
			ob_start();
			?>
			<label for="<?php echo $this->id; ?>" class=""><?php echo JText::_($this->element["label"]); ?></label>
			<?php 
			return ob_get_clean();
        }
		
        public function getInput() {
			ob_start();
			?>
			<span class="color_preview" style="background-color: #<?php echo (!empty($this->value) ? $this->value : "FFFFFF");?>"></span>
			<input class="regular-text color" type="text" id="<?php echo $this->id; ?>" name="<?php echo $this->name; ?>" data-default-color="transparent" value="<?php echo $this->value;?>">
			<?php 
			if(!empty($this->description)) {
				?>
				<span class="description"><?php echo JText::_($this->description); ?></span>
				<?php
			}
			return ob_get_clean();
        }
}